<?php

function replace($data, $content)
{
    if (is_array($data)) 
    {
        $search = array();
        $replace = array();
        foreach ($data as $key => $value) 
        {
            if(!is_array($value))
            {
                $search[] .= '{'.$key.'}';
                $replace[] .= $value;
            }
            else continue;
        }
    }
    else
    {
        $search = '{'.$data.'}';
        $replace = $data;
    }
    return str_replace($search, $replace, $content);
}

function get_title( $domain )  
{
        if (!$content = @file_get_contents( $domain ) )
                return 'Not able to get title';
        else if (!preg_match('~<title>(.*?)</title>~si', $content, $title))
                return 'No title found';

        return $title[1];
}

function check_domain($url){

    // in case scheme relative URI is passed, e.g., //www.google.com/
    $url = trim($url, '/');

    $url = strtolower($url);

    // If scheme not included, prepend it
    if (!preg_match('#^http(s)?://#', $url)) {
        $url = 'http://' . $url;
    }
    $pattern  = '/^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/';
    if(!preg_match($pattern, $url))
    {
        return false;
    }
    if (parse_url($url) == false) 
    {
        return false;
    }
    $urlParts = parse_url($url);

    // remove www
    $domain = preg_replace('/^www\./', '', $urlParts['host']);

    // Check for special charactors
    $domain  = preg_replace('/[^a-zA-Z0-9_.-]/s','',$domain);
    
    return $domain;
}
        
function domainAge($age){

    $age = strtotime($age);
    $current = strtotime(date('Y-m-j'));
    $age = $current - $age;
    $years = floor($age / 31556926);
    $days = round(($age % 31556926) / 86400);

    if($years != 0){
        $age = $years .' years '. $days .' days ';
    }else{
        $age = $days .' days ';
    }
    

    return $age;
}

function php_html_email($email_args) {
    $headers  = 'MIME-Version: 1.0' . "rn";
    $headers .= 'Content-type: text/html; charset=UTF-8' . "rn";
    $headers .=  'To:'.$email_args['to'] . "rn";
    $headers .=  'From:'.$email_args['from'] . "rn";
    if(!empty($email_args['cc'])){$headers .= 'Cc:'.$email_args['cc'] . "rn";}
    $message_body = '<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
    $message_body .= '<title>'.$email_args["subject"].'</title>';
    $message_body .= '</head><body>';
    $message_body .= $email_args["message"];
    $message_body .= '</body></html>';
    if(@mail($email_args['to'], $email_args['subject'], $message_body, $headers))
    {
        return true;
    }else{
        return false;
    }
}

function pagination($per_page = 10, $page = 1, $url = '', $total){

    $adjacents = "2";

    $page = ($page == 0 ? 1 : $page);
    $start = ($page - 1) * $per_page;

    $prev = $page - 1;
    $next = $page + 1;
    $lastpage = ceil($total/$per_page);
    $lpm1 = $lastpage - 1;

    $pagination = "";
    if($lastpage > 1)
    {
        $pagination .= "<ul>";
        $pagination .= "<li class='details'><p> &nbsp;Page $page of $lastpage<p></li>";
        if ($page > 1)
        {
            $pagination.= "<li><a href='{$url}1'>First</a></li>";
            $pagination.= "<li><a href='{$url}$prev'>Prev</a></li>";
        }
        else
        {
            $pagination.= "<li class='active'><a>First</a></li>";
            $pagination.= "<li class='active'><a>Prev</a></li>";
        }
        if ($lastpage < 7 + ($adjacents * 2))
        {
            for ($counter = 1; $counter <= $lastpage; $counter++)
            {

                if ($counter == $page)
                    $pagination.= "<li class='active'><a>$counter</a></li>";
                else
                    $pagination.= "<li><a href='{$url}$counter'>$counter</a></li>";
            }
        }
        elseif($lastpage > 5 + ($adjacents * 2))  
        {
            if($page < 1 + ($adjacents * 2))
            {
                for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++)
                {
                    if ($counter == $page)
                        $pagination.= "<li class='active'><a>$counter</a></li>";
                    else
                        $pagination.= "<li><a href='{$url}$counter'>$counter</a></li>";
                }
                $pagination.= "<li class='dot'><span>...</span></li>";
                $pagination.= "<li><a href='{$url}$lpm1'>$lpm1</a></li>";
                $pagination.= "<li><a href='{$url}$lastpage'>$lastpage</a></li>";
            }
            elseif($lastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2))
            {
                $pagination.= "<li><a href='{$url}1'>1</a></li>";
                $pagination.= "<li><a href='{$url}2'>2</a></li>";
                $pagination.= "<li class='dot'><span>...</span></li>";
                for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++)
                {
                    if ($counter == $page)
                        $pagination.= "<li class='active'><a>$counter</a></li>";
                    else
                        $pagination.= "<li><a href='{$url}$counter'>$counter</a></li>";
                }
                $pagination.= "<li class='dot'><span>..</span></li>";
                $pagination.= "<li><a href='{$url}$lpm1'>$lpm1</a></li>";
                $pagination.= "<li><a href='{$url}$lastpage'>$lastpage</a></li>";
            }
            else
            {
                $pagination.= "<li><a href='{$url}1'>1</a></li>";
                $pagination.= "<li><a href='{$url}2'>2</a></li>";
                $pagination.= "<li class='dot'><span>..</span></li>";
                for ($counter = $lastpage - (2 + ($adjacents * 2)); $counter <= $lastpage; $counter++)
                {
                    if ($counter == $page)
                        $pagination.= "<li class='active'><a>$counter</a></li>";
                    else
                        $pagination.= "<li><a href='{$url}$counter'>$counter</a></li>";
                }
            }
        }

        if ($page < $counter - 1)
        {
            $pagination.= "<li><a href='{$url}$next'>Next</a></li>";
             $pagination.= "<li><a href='{$url}$lastpage'>Last</a></li>";
        }
        else
        {
            $pagination.= "<li class='active'><a>Next</a></li>";
            $pagination.= "<li class='active'><a>Last</a></li>";
        }
        $pagination.= "</ul>\n";
    }
    return $pagination;
}